<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'mobile', 'whatsApp', 'status', 'minimum_charge', 'delivery_cost', 'region_id', 'image');

    public function region()
    {
        return $this->belongsTo('App\Models\Region', 'region_id');
    }

    public function items()
    {
        return $this->hasMany('App\Models\Item');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function commition()
    {
        return $this->hasOne('App\Models\Payment');
    }

    public function notificationts()
    {
        return $this->morphMany('App\Models\Notification');
    }

    public function tokens()
    {
        return $this->morphMany('App\Models\Token');
    }

}